/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.helper.ComponentBase;

public class ByteArrayToXInputStreamAdapter
extends ComponentBase
implements XInputStream,
XSeekable {
    byte[] m_bytes;
    int m_length;
    int m_pos;
    boolean m_open;

    public ByteArrayToXInputStreamAdapter(byte[] byArray) {
        this.init(byArray);
    }

    public void init(byte[] byArray) {
        this.m_bytes = byArray;
        this.m_length = byArray.length;
        this.m_pos = 0;
        this.m_open = true;
    }

    private void _check() throws NotConnectedException, IOException {
        if (this.m_bytes == null) {
            throw new NotConnectedException("no bytes");
        }
        if (!this.m_open) {
            throw new IOException("input closed");
        }
    }

    @Override
    public int available() throws NotConnectedException, IOException {
        this._check();
        long l = this.m_length - this.m_pos;
        if (l != (long)((int)l)) {
            throw new IOException("integer overflow");
        }
        return (int)l;
    }

    @Override
    public void closeInput() throws NotConnectedException, IOException {
        this._check();
        this.m_open = false;
    }

    @Override
    public int readBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        try {
            int n2 = this.m_length - this.m_pos;
            if (n > n2) {
                n = n2;
            }
            if (byArray[0] == null) {
                byArray[0] = new byte[n];
            }
            System.arraycopy(this.m_bytes, this.m_pos, byArray[0], 0, n);
            this.m_pos += n;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw new BufferSizeExceededException("buffer overflow");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("error accessing buffer");
        }
    }

    @Override
    public int readSomeBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        return this.readBytes(byArray, n);
    }

    @Override
    public void skipBytes(int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        if (n > this.m_length - this.m_pos) {
            throw new BufferSizeExceededException("buffer overflow");
        }
        this.m_pos += n;
    }

    @Override
    public long getLength() throws IOException {
        if (this.m_bytes != null) {
            return this.m_length;
        }
        throw new IOException("no bytes");
    }

    @Override
    public long getPosition() throws IOException {
        if (this.m_bytes != null) {
            return this.m_pos;
        }
        throw new IOException("no bytes");
    }

    @Override
    public void seek(long l) throws IllegalArgumentException, IOException {
        if (this.m_bytes != null) {
            if (l < 0L || l > (long)this.m_length) {
                throw new IllegalArgumentException("invalid seek position");
            }
        } else {
            throw new IOException("no bytes");
        }
        this.m_pos = (int)l;
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }
}

