/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogEventHandler;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiEditSettingDialog;
import java.util.Hashtable;

public final class WikiOptionsEventHandlerImpl
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler,
XDialogEventHandler {
    static final String[] m_pServiceNames = new String[]{"com.sun.star.wiki.WikiOptionsEventHandler"};
    static final String m_sImplementationName = WikiOptionsEventHandlerImpl.class.getName();
    static final String sExternalEvent = "external_event";
    static final String sAdd = "Add";
    static final String sEdit = "Edit";
    static final String sRemove = "Remove";
    static final String sListStatus = "ListStatus";
    static final String sListEdit = "ListEdit";
    static final String sInitialize = "initialize";
    static final String sOk = "ok";
    static final String sBack = "back";
    private XComponentContext m_xContext;
    private XDialog m_xDialog;
    private XControlContainer m_xControlContainer;
    Settings m_aSettings;

    public WikiOptionsEventHandlerImpl(XComponentContext xComponentContext) {
        this.m_xContext = xComponentContext;
    }

    protected XPropertySet GetPropSet(String string) {
        if (this.m_xControlContainer != null) {
            XControl xControl = this.m_xControlContainer.getControl(string);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControl.getModel());
            return xPropertySet;
        }
        return null;
    }

    private void RefreshView() {
        if (this.m_aSettings != null) {
            String[] stringArray = this.m_aSettings.getWikiURLs();
            XPropertySet xPropertySet = this.GetPropSet("WikiList");
            if (xPropertySet != null) {
                try {
                    xPropertySet.setPropertyValue("StringItemList", (Object)stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void CheckButtonState() {
        XPropertySet xPropertySet = this.GetPropSet("WikiList");
        if (xPropertySet != null) {
            try {
                short[] sArray = (short[])xPropertySet.getPropertyValue("SelectedItems");
                XPropertySet xPropertySet2 = this.GetPropSet("EditButton");
                XPropertySet xPropertySet3 = this.GetPropSet("RemoveButton");
                Boolean bl = new Boolean(sArray.length != 0);
                xPropertySet2.setPropertyValue("Enabled", (Object)bl);
                xPropertySet3.setPropertyValue("Enabled", (Object)bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void AddSetting() {
        WikiEditSettingDialog wikiEditSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application");
        if (wikiEditSettingDialog.show()) {
            this.RefreshView();
        }
        wikiEditSettingDialog.DisposeDialog();
    }

    private void EditSetting() {
        XPropertySet xPropertySet = this.GetPropSet("WikiList");
        if (xPropertySet != null) {
            Object object;
            Hashtable hashtable = null;
            try {
                object = (short[])xPropertySet.getPropertyValue("SelectedItems");
                String[] stringArray = (String[])xPropertySet.getPropertyValue("StringItemList");
                if (((short[])object).length > 0 && stringArray.length > object[0]) {
                    String string = stringArray[object[0]];
                    hashtable = this.m_aSettings.getSettingByUrl(stringArray[object[0]]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", hashtable, true);
            if (((WikiEditSettingDialog)object).show()) {
                this.RefreshView();
            }
            ((WikiDialog)object).DisposeDialog();
        }
    }

    private void RemoveSetting() {
        XPropertySet xPropertySet = this.GetPropSet("WikiList");
        if (xPropertySet != null) {
            try {
                short[] sArray = (short[])xPropertySet.getPropertyValue("SelectedItems");
                String[] stringArray = (String[])this.GetPropSet("WikiList").getPropertyValue("StringItemList");
                if (sArray.length > 0 && stringArray.length > sArray[0]) {
                    this.m_aSettings.removeSettingByUrl(stringArray[sArray[0]]);
                    this.RefreshView();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void InitStrings() {
        try {
            this.GetPropSet("FixedLine1").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 31));
            this.GetPropSet("AddButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 12));
            this.GetPropSet("EditButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 13));
            this.GetPropSet("RemoveButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 15));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getImplementationName() {
        return m_sImplementationName;
    }

    public boolean supportsService(String string) {
        int n = m_pServiceNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(m_pServiceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_pServiceNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean callHandlerMethod(XWindow xWindow, Object object, String string) throws WrappedTargetException, RuntimeException {
        if (string.equals(sExternalEvent)) {
            try {
                String string2 = AnyConverter.toString((Object)object);
                if (string2 == null) return true;
                if (string2.equals(sOk)) {
                    if (this.m_aSettings == null) return true;
                    this.m_aSettings.storeConfiguration();
                    return true;
                }
                if (!string2.equals(sInitialize) && !string2.equals(sBack)) return true;
                if (string2.equals(sInitialize)) {
                    this.m_xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
                    this.m_xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.m_xDialog);
                    this.m_aSettings = Settings.getSettings(this.m_xContext);
                    this.m_aSettings.loadConfiguration();
                    this.InitStrings();
                } else if (this.m_aSettings != null) {
                    this.m_aSettings.loadConfiguration();
                }
                this.RefreshView();
                this.CheckButtonState();
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (com.sun.star.uno.Exception exception) {
                throw new WrappedTargetException(string, (Object)this, (Object)exception);
            }
        } else if (string.equals(sAdd)) {
            this.AddSetting();
            return true;
        } else if (string.equals(sEdit) || string.equals(sListEdit)) {
            this.EditSetting();
            return true;
        } else if (string.equals(sRemove)) {
            this.RemoveSetting();
            this.CheckButtonState();
            return true;
        } else {
            if (!string.equals(sListStatus)) return true;
            this.CheckButtonState();
        }
        return true;
    }

    public boolean callHandlerMethod(XDialog xDialog, Object object, String string) throws WrappedTargetException, RuntimeException {
        return true;
    }

    public String[] getSupportedMethodNames() {
        return new String[]{sExternalEvent, sAdd, sEdit, sRemove};
    }
}

