/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiPropDialog;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class WikiArticle {
    private XComponentContext m_xContext;
    private String m_sEditTime = "";
    private String m_sEditToken = "";
    protected String m_sHTMLCode;
    private boolean m_bNoArticle = true;
    protected String m_sWikiUser;
    protected String m_sWikiPass;
    protected String m_sTitle = "";
    private URI m_aMainURI;
    private HostConfiguration m_aHostConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiArticle(XComponentContext xComponentContext, String string, Hashtable hashtable, boolean bl, WikiPropDialog wikiPropDialog) throws MalformedURLException, Exception, IOException, WikiCancelException {
        this.m_xContext = xComponentContext;
        String string2 = (String)hashtable.get("Url");
        this.m_sWikiUser = (String)hashtable.get("Username");
        this.m_sWikiPass = (String)hashtable.get("Password");
        this.m_sTitle = string;
        this.m_aMainURI = new URI(string2);
        if (bl) {
            WikiEditSettingDialog wikiEditSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", hashtable, false);
            try {
                while (!this.Login()) {
                    if (wikiPropDialog != null) {
                        wikiPropDialog.SetThrobberActive(false);
                    }
                    if (!MainThreadDialogExecutor.Show(xComponentContext, wikiEditSettingDialog)) {
                        throw new WikiCancelException();
                    }
                    this.m_sWikiUser = (String)hashtable.get("Username");
                    this.m_sWikiPass = (String)hashtable.get("Password");
                    if (wikiPropDialog == null) continue;
                    wikiPropDialog.SetThrobberActive(true);
                    Thread.yield();
                }
            }
            finally {
                wikiEditSettingDialog.DisposeDialog();
            }
        }
        this.InitArticleHTML();
    }

    public String GetMainURL() {
        return this.m_aMainURI.toString();
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    public String GetViewURL() {
        return this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle;
    }

    private String getArticleWiki() throws Exception, IOException, WikiCancelException {
        String string = null;
        if (this.m_aHostConfig != null) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=edit");
            GetMethod getMethod = new GetMethod(uRI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)getMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = getMethod.getStatusCode();
            String string2 = null;
            if (n == 200) {
                string2 = getMethod.getResponseBodyAsString();
            }
            getMethod.releaseConnection();
            if (string2 != null) {
                StringReader stringReader = new StringReader(string2);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                this.m_sEditTime = editPageParser.m_sEditTime;
                this.m_sEditToken = editPageParser.m_sEditToken;
                int n2 = editPageParser.m_nWikiArticleStart;
                int n3 = editPageParser.m_nWikiArticleEnd;
                if (n2 >= 0 && n3 > 0) {
                    String string3 = string2.substring(n2, n3);
                    n2 = string3.indexOf(">") + 1;
                    string = string3.substring(n2, string3.length());
                }
            }
        }
        return string;
    }

    private void InitArticleHTML() throws Exception, IOException, WikiCancelException {
        if (this.m_aHostConfig != null) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle);
            GetMethod getMethod = new GetMethod(uRI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)getMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = getMethod.getStatusCode();
            String string = null;
            if (n == 200) {
                string = getMethod.getResponseBodyAsString();
            }
            if (string != null) {
                StringReader stringReader = new StringReader(string);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                int n2 = editPageParser.m_nHTMLArticleStart;
                int n3 = editPageParser.m_nHTMLArticleEnd;
                int n4 = editPageParser.m_nNoArticleInd;
                if (n2 >= 0 && n3 > 0) {
                    this.m_sHTMLCode = string.substring(n2, n3);
                    this.m_bNoArticle = n4 >= 0 && n4 >= n2 && n4 <= n3;
                }
            }
        }
    }

    protected boolean setArticle(String string, String string2, boolean bl) throws Exception, IOException, WikiCancelException {
        boolean bl2 = false;
        if (this.m_aHostConfig != null && string != null && string2 != null) {
            this.getArticleWiki();
            URI uRI = new URI(this.m_aMainURI.getPath() + "index.php?title=" + this.m_sTitle + "&action=submit");
            PostMethod postMethod = new PostMethod();
            postMethod.setPath(uRI.getEscapedPathQuery());
            postMethod.addParameter("wpTextbox1", string);
            postMethod.addParameter("wpSummary", string2);
            postMethod.addParameter("wpSection", "");
            postMethod.addParameter("wpEdittime", this.m_sEditTime);
            postMethod.addParameter("wpSave", "Save page");
            postMethod.addParameter("wpEditToken", this.m_sEditToken);
            if (bl) {
                postMethod.addParameter("wpMinoredit", "1");
            }
            Helper.ExecuteMethod((HttpMethodBase)postMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = postMethod.getStatusCode();
            if (n < 400) {
                bl2 = true;
            }
            String string3 = postMethod.getResponseBodyAsString();
            System.out.print("nSubmitCode = " + n + "\n===\n" + string3);
        }
        return bl2;
    }

    protected boolean Login() throws Exception, IOException, WikiCancelException {
        this.m_aHostConfig = Helper.Login(this.m_aMainURI, this.m_sWikiUser, this.m_sWikiPass, this.m_xContext);
        return this.m_aHostConfig != null;
    }

    protected void cleanHTML() {
        if (this.m_sHTMLCode != null) {
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<![ \\r\\n\\t]*(--([^\\-]|[\\r\\n]|-[^\\-])*--[ \\r\\n\\t]*)\\>", "");
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<div class=\"editsection\".*?\\</div\\>", "");
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<p\\>\\<br /\\>[ \r\n\t]*?\\</p\\>", "");
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<table.*id=\"toc\"(.|[\r\n])*?\\</table\\>", "");
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<div id=\"jump-to-nav\".*?\\</div\\>", "");
            this.m_sHTMLCode = this.m_sHTMLCode.replaceAll("\\<script(.|[\r\n])*?\\</script\\>", "");
        }
    }

    protected boolean NotExist() {
        boolean bl = true;
        if (this.m_sHTMLCode != null) {
            bl = this.m_bNoArticle;
        }
        return bl;
    }
}

