/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.report.DataSource;
import com.sun.star.report.DataSourceException;
import com.sun.star.sdb.XParametersSupplier;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSetMetaData;
import com.sun.star.sdbc.XResultSetMetaDataSupplier;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class SDBCReportData
implements DataSource {
    private final XRowSet rowSet;
    private final XRow row;
    private int rowCount;
    private XIndexAccess parameters;
    private int firstParameterIndex = -1;
    private int columnCount;
    private final String[] columnNames;
    private final int[] columnTypes;

    public SDBCReportData(XRowSet xRowSet) throws SQLException {
        this.row = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xRowSet);
        this.rowSet = xRowSet;
        if (xRowSet == null) {
            this.rowCount = 0;
            this.columnCount = 0;
            this.columnTypes = new int[1];
            this.columnNames = new String[1];
        } else {
            XParametersSupplier xParametersSupplier = (XParametersSupplier)UnoRuntime.queryInterface(XParametersSupplier.class, (Object)xRowSet);
            if (xParametersSupplier != null) {
                this.parameters = xParametersSupplier.getParameters();
            }
            XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)xRowSet);
            XNameAccess xNameAccess = xColumnsSupplier.getColumns();
            String[] stringArray = xNameAccess.getElementNames();
            XResultSetMetaDataSupplier xResultSetMetaDataSupplier = (XResultSetMetaDataSupplier)UnoRuntime.queryInterface(XResultSetMetaDataSupplier.class, (Object)xRowSet);
            XResultSetMetaData xResultSetMetaData = xResultSetMetaDataSupplier.getMetaData();
            this.columnCount = xResultSetMetaData.getColumnCount();
            this.firstParameterIndex = this.columnCount + 1;
            if (this.parameters != null) {
                this.columnCount += this.parameters.getCount();
            }
            this.columnTypes = new int[this.columnCount];
            this.columnNames = new String[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                if (i < this.firstParameterIndex) {
                    this.columnNames[i - 1] = stringArray[i - 1];
                    this.columnTypes[i - 1] = xResultSetMetaData.getColumnType(i);
                    continue;
                }
                try {
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.parameters.getByIndex(i - this.firstParameterIndex));
                    this.columnNames[i - 1] = (String)xPropertySet.getPropertyValue("Name");
                    this.columnTypes[i - 1] = (Integer)xPropertySet.getPropertyValue("Type");
                    continue;
                }
                catch (Exception exception) {
                    this.columnNames[i - 1] = "Error";
                    this.columnTypes[i - 1] = 1;
                }
            }
            if (xRowSet.last()) {
                this.rowCount = xRowSet.getRow();
                xRowSet.beforeFirst();
            } else {
                this.rowCount = 0;
            }
        }
    }

    @Override
    public int getColumnCount() throws DataSourceException {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int n) throws DataSourceException {
        return this.columnNames[n - 1];
    }

    @Override
    public boolean absolute(int n) throws DataSourceException {
        if (this.rowSet == null) {
            return false;
        }
        try {
            if (n == 0) {
                this.rowSet.beforeFirst();
                return true;
            }
            return this.rowSet.absolute(n);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean next() throws DataSourceException {
        if (this.rowSet == null) {
            return false;
        }
        try {
            return this.rowSet.next();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void close() throws DataSourceException {
    }

    private static Date getDate(Object object) {
        Date date;
        if (object instanceof com.sun.star.util.Date) {
            com.sun.star.util.Date date2 = (com.sun.star.util.Date)object;
            date = Date.valueOf(SDBCReportData.getDateString(date2.Year, date2.Month, date2.Day).toString());
        } else {
            date = null;
        }
        return date;
    }

    private static StringBuffer getTimeString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer;
    }

    private static StringBuffer getDateString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        StringBuffer stringBuffer2 = new StringBuffer("0000");
        stringBuffer2.delete(0, stringBuffer.length());
        stringBuffer.insert(0, stringBuffer2);
        stringBuffer.append('-');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer;
    }

    private static Time getTime(Object object) {
        Time time;
        if (object instanceof com.sun.star.util.Time) {
            com.sun.star.util.Time time2 = (com.sun.star.util.Time)object;
            time = Time.valueOf(SDBCReportData.getTimeString(time2.Hours, time2.Minutes, time2.Seconds).toString());
        } else {
            time = null;
        }
        return time;
    }

    private static Timestamp getTimestamp(Object object) {
        Timestamp timestamp;
        if (object instanceof DateTime) {
            DateTime dateTime = (DateTime)object;
            StringBuffer stringBuffer = SDBCReportData.getDateString(dateTime.Year, dateTime.Month, dateTime.Day);
            stringBuffer.append(' ');
            stringBuffer.append(SDBCReportData.getTimeString(dateTime.Hours, dateTime.Minutes, dateTime.Seconds));
            stringBuffer.append('.');
            stringBuffer.append(dateTime.HundredthSeconds);
            timestamp = Timestamp.valueOf(stringBuffer.toString());
        } else {
            timestamp = null;
        }
        return timestamp;
    }

    @Override
    public Object getObject(int n) throws DataSourceException {
        if (this.rowSet == null) {
            return null;
        }
        try {
            boolean bl;
            Object object;
            boolean bl2;
            boolean bl3 = bl2 = this.parameters != null && n >= this.firstParameterIndex;
            if (bl2) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.parameters.getByIndex(n - this.firstParameterIndex));
                object = xPropertySet.getPropertyValue("Value");
                bl = object == null;
            } else {
                object = this.row.getObject(n, null);
                bl = this.row.wasNull();
            }
            object = bl ? null : this.convertObject(this.columnTypes[n - 1], object);
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException(sQLException.getMessage(), sQLException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new DataSourceException(unknownPropertyException.getMessage(), unknownPropertyException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DataSourceException(indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new DataSourceException(wrappedTargetException.getMessage(), wrappedTargetException);
        }
    }

    private Object convertObject(int n, Object object) {
        Object object2;
        switch (n) {
            case 91: {
                object2 = SDBCReportData.getDate(object);
                break;
            }
            case 92: {
                object2 = SDBCReportData.getTime(object);
                break;
            }
            case 93: {
                object2 = SDBCReportData.getTimestamp(object);
                break;
            }
            case 2: 
            case 3: {
                if (!(object instanceof Any)) {
                    try {
                        object2 = new BigDecimal(String.valueOf(object));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2 = object;
                    }
                    break;
                }
                object2 = object;
                break;
            }
            default: {
                object2 = object;
            }
        }
        return object2;
    }
}

