/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JLabel;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Tree
extends DescendantManager
implements Accessible {
    protected Tree(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible accessible) {
        Accessible accessible2 = this.activeDescendant;
        this.activeDescendant = accessible;
        this.firePropertyChange("AccessibleActiveDescendant", accessible2, accessible);
    }

    protected void setActiveDescendant(Object object) {
        TreeItem treeItem = null;
        try {
            XAccessible xAccessible;
            if (AnyConverter.isObject((Object)object) && (xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object)) != null) {
                treeItem = new TreeItem(xAccessible);
            }
            this.setActiveDescendant(treeItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", null, new TreeItem(xAccessible));
        }
    }

    protected void remove(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", new TreeItem(xAccessible), null);
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTreeListener();
    }

    @Override
    public AccessibleContext createAccessibleContext() {
        return new AccessibleTree();
    }

    class TreeItem
    extends Component
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public TreeItem(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] objectArray) {
            try {
                ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)objectArray[i]);
                    if (xAccessible == null) continue;
                    arrayList.add(new TreeItem(xAccessible));
                }
                arrayList.trimToSize();
                return arrayList.toArray();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    AccessibleTreeItem accessibleTreeItem;
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null && (accessibleTreeItem = new AccessibleTreeItem(xAccessibleContext)) != null) {
                        accessibleTreeItem.setAccessibleParent(Tree.this);
                        this.accessibleContext = accessibleTreeItem;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleTreeItem
        extends AccessibleContext
        implements AccessibleSelection {
            XAccessibleContext unoAccessibleContext;
            XAccessibleSelection unoAccessibleSelection;

            public AccessibleTreeItem(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
                this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xAccessibleContext);
            }

            @Override
            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public void setAccessibleName(String string) {
            }

            @Override
            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public void setAccessibleDescription(String string) {
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole accessibleRole = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return accessibleRole != null ? accessibleRole : AccessibleRole.LABEL;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale locale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(locale.Language, locale.Country);
                }
                catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                    throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    return Tree.this.getLocale();
                }
            }

            @Override
            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
            }

            @Override
            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                Accessible accessible = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    Accessible accessible2 = Tree.this.activeDescendant;
                    if (accessible2 instanceof TreeItem && ((TreeItem)accessible2).unoAccessible.equals(xAccessible)) {
                        accessible = accessible2;
                    } else if (xAccessible != null) {
                        accessible = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return accessible;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(TreeItem.this, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException runtimeException) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.unoAccessibleContext);
                    return xAccessibleComponent != null ? new AccessibleComponentImpl(xAccessibleComponent) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.unoAccessibleSelection != null ? this : null;
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)this.unoAccessibleContext);
                    return xAccessibleAction != null ? new AccessibleActionImpl(xAccessibleAction) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public AccessibleText getAccessibleText() {
                if (Tree.this.disposed) {
                    return null;
                }
                try {
                    XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.unoAccessibleContext);
                    return xAccessibleText != null ? new AccessibleTextImpl(xAccessibleText) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(XAccessibleValue.class, (Object)this.unoAccessibleContext);
                    return xAccessibleValue != null ? new AccessibleValueImpl(xAccessibleValue) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage xAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface(XAccessibleImage.class, (Object)this.unoAccessibleContext);
                    if (xAccessibleImage != null) {
                        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{new AccessibleIconImpl(xAccessibleImage)};
                        return accessibleIconArray;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public Accessible getAccessibleSelection(int n) {
                TreeItem treeItem = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    if (xAccessible != null) {
                        treeItem = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return treeItem;
            }

            @Override
            public void addAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.selectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            @Override
            public void clearAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.clearAccessibleSelection();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            @Override
            public int getAccessibleSelectionCount() {
                try {
                    return this.unoAccessibleSelection.getSelectedAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            @Override
            public boolean isAccessibleChildSelected(int n) {
                try {
                    return this.unoAccessibleSelection.isAccessibleChildSelected(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }

            @Override
            public void removeAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.deselectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            @Override
            public void selectAllAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.selectAllAccessibleChildren();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    protected class AccessibleTree
    extends DescendantManager.AccessibleDescendantManager
    implements AccessibleExtendedTable {
        protected XAccessibleTable unoAccessibleTable;

        public AccessibleTree() {
            this.unoAccessibleTable = (XAccessibleTable)UnoRuntime.queryInterface(XAccessibleTable.class, (Object)Tree.this.unoAccessibleContext);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        @Override
        public AccessibleTable getAccessibleTable() {
            return this.unoAccessibleTable != null ? this : null;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = Tree.this.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        @Override
        public Accessible getAccessibleAt(java.awt.Point point) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y));
                if (xAccessible != null) {
                    Accessible accessible2 = Tree.this.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(xAccessible);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = Tree.this.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        @Override
        public Accessible getAccessibleAt(int n, int n2) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.unoAccessibleTable.getAccessibleCellAt(n, n2);
                if (xAccessible != null) {
                    Accessible accessible2 = Tree.this.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        @Override
        public Accessible getAccessibleCaption() {
            return null;
        }

        @Override
        public int getAccessibleColumnCount() {
            try {
                return this.unoAccessibleTable.getAccessibleColumnCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        @Override
        public Accessible getAccessibleColumnDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleColumnDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public int getAccessibleColumnExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleColumnExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        @Override
        public AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        @Override
        public int getAccessibleRowCount() {
            try {
                return this.unoAccessibleTable.getAccessibleRowCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        @Override
        public Accessible getAccessibleRowDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleRowDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public int getAccessibleRowExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleRowExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        @Override
        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        @Override
        public Accessible getAccessibleSummary() {
            return null;
        }

        @Override
        public int[] getSelectedAccessibleColumns() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleColumns();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public int[] getSelectedAccessibleRows() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleRows();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public boolean isAccessibleColumnSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleColumnSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public boolean isAccessibleRowSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleRowSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public boolean isAccessibleSelected(int n, int n2) {
            try {
                return this.unoAccessibleTable.isAccessibleSelected(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public void setAccessibleCaption(Accessible accessible) {
        }

        @Override
        public void setAccessibleColumnDescription(int n, Accessible accessible) {
        }

        @Override
        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        @Override
        public void setAccessibleRowDescription(int n, Accessible accessible) {
        }

        @Override
        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        @Override
        public void setAccessibleSummary(Accessible accessible) {
        }

        @Override
        public int getAccessibleColumn(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleColumn(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        @Override
        public int getAccessibleIndex(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleIndex(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        @Override
        public int getAccessibleRow(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleRow(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }
    }

    protected class AccessibleTreeListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleTreeListener() {
        }

        @Override
        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 5: {
                    Tree.this.setActiveDescendant(accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        Tree.this.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    Tree.this.add(accessibleEventObject.NewValue);
                    break;
                }
                case 32: {
                    Tree.this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
                    break;
                }
                case 33: {
                    Tree.this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

