/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Component;
import org.openoffice.java.accessibility.MenuItem;

public class Menu
extends AbstractButton
implements Accessible {
    private Vector children;
    protected XAccessibleSelection unoAccessibleSelection = null;

    protected Menu(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
        try {
            int n = this.unoAccessibleContext.getAccessibleChildCount();
            this.children = new Vector(n);
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(this.unoAccessibleContext.getAccessibleChild(i));
                if (component == null) continue;
                this.children.add(component);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.children == null) {
                this.children = new Vector(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected synchronized void add(XAccessible xAccessible) {
        Component component = this.getComponent(xAccessible);
        if (component != null) {
            try {
                this.children.add(xAccessible.getAccessibleContext().getAccessibleIndexInParent(), component);
                this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected synchronized void remove(XAccessible xAccessible) {
        Component component = this.getComponent(xAccessible);
        if (component != null) {
            try {
                this.children.remove(component);
                this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected synchronized int indexOf(Object object) {
        return this.children.indexOf(object);
    }

    protected Component getComponent(XAccessible xAccessible) {
        Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
        if (component == null && (component = AccessibleObjectFactory.createAccessibleComponent(xAccessible)) instanceof Accessible) {
            ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
        }
        return component;
    }

    @Override
    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuListener();
    }

    @Override
    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenu();
    }

    protected class AccessibleMenu
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection {
        protected AccessibleMenu() {
            Menu.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)Menu.this.unoAccessibleContext);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() instanceof Menu) {
                return ((Menu)this.getAccessibleParent()).indexOf(Menu.this);
            }
            return super.getAccessibleIndexInParent();
        }

        @Override
        public synchronized int getAccessibleChildrenCount() {
            return Menu.this.children.size();
        }

        @Override
        public synchronized Accessible getAccessibleChild(int n) {
            try {
                if (n < Menu.this.children.size()) {
                    return (Accessible)Menu.this.children.get(n);
                }
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Menu.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            try {
                return (Accessible)((Object)Menu.this.getComponent(Menu.this.unoAccessibleSelection.getSelectedAccessibleChild(n)));
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void addAccessibleSelection(int n) {
            try {
                Accessible accessible = this.getAccessibleChild(n);
                if (accessible instanceof MenuItem) {
                    accessible.getAccessibleContext().getAccessibleAction().doAccessibleAction(0);
                } else {
                    Menu.this.unoAccessibleSelection.selectAccessibleChild(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearAccessibleSelection() {
            try {
                Menu.this.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        @Override
        public int getAccessibleSelectionCount() {
            try {
                return Menu.this.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            try {
                return Menu.this.unoAccessibleSelection.isAccessibleChildSelected(n);
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (this.isAccessibleChildSelected(n)) {
                this.clearAccessibleSelection();
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    protected class AccessibleMenuListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleMenuListener() {
        }

        @Override
        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        Menu.this.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    Menu.this.add(accessibleEventObject.NewValue);
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

