/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.style.LineSpacing;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.text.BreakIterator;
import java.util.Arrays;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;

public class AccessibleTextImpl
implements AccessibleText {
    static final double toPointFactor = 0.028985507246376812;
    static final String[] attributeList = new String[]{"ParaAdjust", "CharBackColor", "CharWeight", "ParaFirstLineIndent", "CharFontPitch", "CharHeight", "CharColor", "CharPosture", "ParaLeftMargin", "ParaLineSpacing", "ParaTopMargin", "ParaBottomMargin", "CharStrikeout", "CharEscapement", "ParaTabStops", "CharUnderline"};
    static final String[] localeAttributeList = new String[]{"CharLocale", "CharLocaleAsian", "CharLocaleComplex"};
    XAccessibleText unoObject;
    private TabSet tabSet = null;
    private javax.swing.text.TabStop[] tabStops = null;
    private static Type TextSegmentType = new Type(TextSegment.class);
    private static Type UnoLocaleType = new Type(Locale.class);

    public AccessibleTextImpl(XAccessibleText xAccessibleText) {
        this.unoObject = xAccessibleText;
    }

    public AccessibleTextImpl() {
    }

    public static AccessibleText get(XInterface xInterface) {
        try {
            XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xInterface);
            if (xAccessibleText != null) {
                return new AccessibleTextImpl(xAccessibleText);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    protected static Object convertTextSegment(Object object) {
        try {
            TextSegment textSegment;
            if (AnyConverter.isObject((Object)object) && (textSegment = (TextSegment)AnyConverter.toObject((Type)TextSegmentType, (Object)object)) != null) {
                Object[] objectArray = new Object[]{new Integer(textSegment.SegmentStart), new Integer(textSegment.SegmentEnd), textSegment.SegmentText};
                return objectArray;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected java.util.Locale getLocale(int n) {
        try {
            PropertyValue[] propertyValueArray = this.unoObject.getCharacterAttributes(n, localeAttributeList);
            if (null != propertyValueArray) {
                for (int i = 0; i < propertyValueArray.length; ++i) {
                    Locale locale = (Locale)AnyConverter.toObject((Type)UnoLocaleType, (Object)propertyValueArray[i]);
                    if (locale == null) continue;
                    return new java.util.Locale(locale.Language, locale.Country);
                }
            }
            return java.util.Locale.getDefault();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return java.util.Locale.getDefault();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return java.util.Locale.getDefault();
        }
    }

    @Override
    public String getAfterIndex(int n, int n2) {
        switch (n) {
            case 1: {
                try {
                    String string = this.unoObject.getText();
                    return string.substring(n2 + 1, n2 + 2);
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 2: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    if (n3 == -1 || n3 >= string.length()) {
                        return null;
                    }
                    int n4 = breakIterator.following(n3);
                    if (n4 == -1 || n4 >= string.length()) {
                        return null;
                    }
                    return string.substring(n3, n4);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 3: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    if (n5 == -1 || n5 >= string.length()) {
                        return null;
                    }
                    int n6 = breakIterator.following(n5);
                    if (n6 == -1 || n6 >= string.length()) {
                        return null;
                    }
                    return string.substring(n5, n6);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment textSegment = this.unoObject.getTextBehindIndex(n2, (short)5);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n2 > 0 && this.getCharCount() == n2) {
                        return this.getAfterIndex(n, n2 - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment textSegment = this.unoObject.getTextBehindIndex(n2, (short)7);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public int getCaretPosition() {
        try {
            return this.unoObject.getCaretPosition();
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    @Override
    public int getSelectionStart() {
        try {
            int n = this.unoObject.getSelectionStart();
            if (n == -1) {
                n = this.getCaretPosition();
            }
            return n;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    protected void setAttribute(MutableAttributeSet mutableAttributeSet, PropertyValue propertyValue) {
        try {
            if (propertyValue.Name.equals("ParaAdjust")) {
                ParagraphAdjust paragraphAdjust = null;
                paragraphAdjust = propertyValue.Value instanceof ParagraphAdjust ? (ParagraphAdjust)propertyValue.Value : (propertyValue.Value instanceof Any ? (ParagraphAdjust)AnyConverter.toObject((Type)new Type(ParagraphAdjust.class), (Object)propertyValue.Value) : ParagraphAdjust.fromInt((int)AnyConverter.toInt((Object)propertyValue.Value)));
                if (paragraphAdjust != null) {
                    if (paragraphAdjust.equals(ParagraphAdjust.LEFT)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 0);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.RIGHT)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 2);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.CENTER)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 1);
                    } else if (paragraphAdjust.equals(ParagraphAdjust.BLOCK) || paragraphAdjust.equals(ParagraphAdjust.STRETCH)) {
                        StyleConstants.setAlignment(mutableAttributeSet, 3);
                    }
                }
            } else if (propertyValue.Name.equals("CharBackColor")) {
                StyleConstants.setBackground(mutableAttributeSet, new Color(AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharWeight")) {
                boolean bl = AnyConverter.toFloat((Object)propertyValue.Value) > 125.0f;
                StyleConstants.setBold(mutableAttributeSet, bl);
            } else if (propertyValue.Name.equals("ParaFirstLineIndent")) {
                StyleConstants.setFirstLineIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharFontPitch")) {
                if (AnyConverter.toShort((Object)propertyValue.Value) == 2) {
                    StyleConstants.setFontFamily(mutableAttributeSet, "Proportional");
                }
            } else if (propertyValue.Name.equals("CharHeight")) {
                StyleConstants.setFontSize(mutableAttributeSet, (int)AnyConverter.toFloat((Object)propertyValue.Value));
            } else if (propertyValue.Name.equals("CharColor")) {
                StyleConstants.setForeground(mutableAttributeSet, new Color(AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharPosture")) {
                FontSlant fontSlant = null;
                if (propertyValue.Value instanceof FontSlant) {
                    fontSlant = (FontSlant)propertyValue.Value;
                } else if (propertyValue.Value instanceof Any) {
                    fontSlant = (FontSlant)AnyConverter.toObject((Type)new Type(FontSlant.class), (Object)propertyValue.Value);
                }
                if (fontSlant != null) {
                    StyleConstants.setItalic(mutableAttributeSet, FontSlant.ITALIC.equals(fontSlant));
                }
            } else if (propertyValue.Name.equals("ParaLeftMargin")) {
                StyleConstants.setLeftIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaRightMargin")) {
                StyleConstants.setRightIndent(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaLineSpacing")) {
                LineSpacing lineSpacing = null;
                if (propertyValue.Value instanceof LineSpacing) {
                    lineSpacing = (LineSpacing)propertyValue.Value;
                } else if (propertyValue.Value instanceof Any) {
                    lineSpacing = (LineSpacing)AnyConverter.toObject((Type)new Type(LineSpacing.class), (Object)propertyValue.Value);
                }
                if (lineSpacing != null) {
                    StyleConstants.setLineSpacing(mutableAttributeSet, (float)(0.028985507246376812 * (double)lineSpacing.Height));
                }
            } else if (propertyValue.Name.equals("ParaTopMargin")) {
                StyleConstants.setSpaceAbove(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("ParaBottomMargin")) {
                StyleConstants.setSpaceBelow(mutableAttributeSet, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)propertyValue.Value)));
            } else if (propertyValue.Name.equals("CharStrikeout")) {
                boolean bl = 0 != AnyConverter.toShort((Object)propertyValue.Value);
                StyleConstants.setStrikeThrough(mutableAttributeSet, bl);
            } else if (propertyValue.Name.equals("CharEscapement")) {
                short s = AnyConverter.toShort((Object)propertyValue.Value);
                if (s > 0) {
                    StyleConstants.setSuperscript(mutableAttributeSet, true);
                } else if (s < 0) {
                    StyleConstants.setSubscript(mutableAttributeSet, true);
                }
            } else if (propertyValue.Name.equals("ParaTabStops")) {
                TabStop[] tabStopArray = (TabStop[])AnyConverter.toArray((Object)propertyValue.Value);
                Object[] objectArray = new javax.swing.text.TabStop[tabStopArray.length];
                for (int i = 0; i < tabStopArray.length; ++i) {
                    float f = (float)(0.028985507246376812 * (double)tabStopArray[i].Position);
                    objectArray[i] = tabStopArray[i].Alignment.equals(TabAlign.LEFT) ? new javax.swing.text.TabStop(f, 0, 0) : (tabStopArray[i].Alignment.equals(TabAlign.CENTER) ? new javax.swing.text.TabStop(f, 2, 0) : (tabStopArray[i].Alignment.equals(TabAlign.RIGHT) ? new javax.swing.text.TabStop(f, 1, 0) : (tabStopArray[i].Alignment.equals(TabAlign.DECIMAL) ? new javax.swing.text.TabStop(f, 4, 0) : new javax.swing.text.TabStop(f))));
                }
                if (this.tabSet == null || !Arrays.equals(objectArray, this.tabStops)) {
                    this.tabStops = objectArray;
                    this.tabSet = new TabSet((javax.swing.text.TabStop[])objectArray);
                }
                StyleConstants.setTabSet(mutableAttributeSet, this.tabSet);
            } else if (propertyValue.Name.equals("CharUnderline")) {
                boolean bl = 0 != AnyConverter.toShort((Object)propertyValue.Value);
                StyleConstants.setUnderline(mutableAttributeSet, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public AttributeSet getCharacterAttribute(int n) {
        try {
            PropertyValue[] propertyValueArray = this.unoObject.getCharacterAttributes(n, attributeList);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (null != propertyValueArray) {
                for (int i = 0; i < propertyValueArray.length; ++i) {
                    this.setAttribute(simpleAttributeSet, propertyValueArray[i]);
                }
            }
            return simpleAttributeSet;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n > 0 && this.getCharCount() == n) {
                return this.getCharacterAttribute(n - 1);
            }
            return null;
        }
    }

    @Override
    public int getIndexAtPoint(java.awt.Point point) {
        try {
            return this.unoObject.getIndexAtPoint(new Point(point.x, point.y));
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    @Override
    public int getSelectionEnd() {
        try {
            int n = this.unoObject.getSelectionEnd();
            if (n == -1) {
                n = this.getCaretPosition();
            }
            return n;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    @Override
    public String getBeforeIndex(int n, int n2) {
        switch (n) {
            case 1: {
                try {
                    String string = this.unoObject.getText();
                    return string.substring(n2 - 1, n2);
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 2: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    n3 = breakIterator.previous();
                    int n4 = breakIterator.previous();
                    if (n4 == -1) {
                        return null;
                    }
                    return string.substring(n4, n3);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 3: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n2);
                    n5 = breakIterator.previous();
                    int n6 = breakIterator.previous();
                    if (n6 == -1) {
                        return null;
                    }
                    return string.substring(n6, n5);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment textSegment = this.unoObject.getTextBeforeIndex(n2, (short)5);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n2 > 0 && this.getCharCount() == n2) {
                        return this.getBeforeIndex(n, n2 - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment textSegment = this.unoObject.getTextBeforeIndex(n2, (short)7);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public String getAtIndex(int n, int n2) {
        switch (n) {
            case 1: {
                try {
                    String string = this.unoObject.getText();
                    return string.substring(n2, n2 + 1);
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 2: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n3 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n3);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 3: {
                try {
                    String string = this.unoObject.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale(n2));
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n2);
                    return string.substring(breakIterator.previous(), n4);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment textSegment = this.unoObject.getTextAtIndex(n2, (short)5);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n2 > 0 && this.getCharCount() == n2) {
                        return this.getAtIndex(n, n2 - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment textSegment = this.unoObject.getTextAtIndex(n2, (short)7);
                    return textSegment.SegmentText;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public int getCharCount() {
        try {
            return this.unoObject.getCharacterCount();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    @Override
    public String getSelectedText() {
        try {
            return this.unoObject.getSelectedText();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public java.awt.Rectangle getCharacterBounds(int n) {
        try {
            Rectangle rectangle = this.unoObject.getCharacterBounds(n);
            return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n > 0 && this.getCharCount() == n) {
                return this.getCharacterBounds(n - 1);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new java.awt.Rectangle();
    }
}

