/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view.text;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class TextActionDialog
extends JDialog
implements ActionListener {
    private XAccessibleContext mxContext;
    protected JTextArea maText;
    private String msTitle;
    private String msExplanation;
    private JCheckBox maIndexToggle;

    public TextActionDialog(XAccessibleContext xAccessibleContext, String string, String string2) {
        this.mxContext = xAccessibleContext;
        this.msTitle = string2;
        this.msExplanation = string;
        this.Layout();
        this.setSize(350, 225);
    }

    protected void Layout() {
        this.setTitle(this.msTitle);
        Container container = this.getContentPane();
        if (this.msExplanation.length() > 0) {
            container.add((Component)new JLabel(this.msExplanation), "North");
        }
        this.maText = new JTextArea();
        this.maText.setLineWrap(true);
        this.maText.setEditable(false);
        container.add((Component)this.maText, "Center");
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.mxContext);
        String string = xAccessibleText.getText();
        this.maText.setText(string);
        this.maText.setRows(string.length() / 40 + 1);
        this.maText.setColumns(Math.min(Math.max(40, string.length()), 20));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.maIndexToggle = new JCheckBox("reverse selection");
        jPanel.add(this.maIndexToggle);
        JButton jButton = new JButton(this.msTitle);
        jButton.setActionCommand("Action");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("cancel");
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        container.add((Component)jPanel, "South");
    }

    protected void Cancel() {
        this.hide();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Cancel".equals(string)) {
            this.Cancel();
        } else if ("Action".equals(string)) {
            this.Action();
        }
    }

    protected int GetSelectionStart() {
        return this.GetSelection(true);
    }

    protected int GetSelectionEnd() {
        return this.GetSelection(false);
    }

    private int GetSelection(boolean bl) {
        if (bl ^ this.maIndexToggle.isSelected()) {
            return this.maText.getSelectionStart();
        }
        return this.maText.getSelectionEnd();
    }

    protected void Action() {
        String string = null;
        boolean bl = true;
        try {
            XAccessibleEditableText xAccessibleEditableText;
            XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.mxContext);
            if (xAccessibleText != null) {
                boolean bl2 = bl = bl && this.TextAction(xAccessibleText);
            }
            if ((xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)this.mxContext)) != null) {
                boolean bl3 = bl = bl && this.EditableTextAction(xAccessibleEditableText);
            }
            if (!bl) {
                string = "Can't execute";
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "Index out of bounds";
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, this.msTitle, 0);
        }
        this.Cancel();
    }

    boolean TextAction(XAccessibleText xAccessibleText) throws IndexOutOfBoundsException {
        return true;
    }

    boolean EditableTextAction(XAccessibleEditableText xAccessibleEditableText) throws IndexOutOfBoundsException {
        return true;
    }
}

