/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view.text;

import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import java.util.Vector;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CaretSpinnerModel
implements SpinnerModel {
    private XAccessibleText mxText;
    private Integer maValue;
    private Vector maListeners;

    public CaretSpinnerModel(XAccessibleText xAccessibleText) {
        this.mxText = xAccessibleText;
        this.maListeners = new Vector();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.maListeners.add(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.maListeners.removeElement(changeListener);
    }

    @Override
    public Object getNextValue() {
        int n;
        if (this.mxText != null && (n = this.mxText.getCaretPosition()) + 1 <= this.mxText.getCharacterCount()) {
            return new Integer(n + 1);
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        int n;
        if (this.mxText != null && (n = this.mxText.getCaretPosition()) > 0) {
            return new Integer(n - 1);
        }
        return null;
    }

    @Override
    public Object getValue() {
        if (this.mxText != null) {
            return new Integer(this.mxText.getCaretPosition());
        }
        return null;
    }

    @Override
    public void setValue(Object object) {
        if (this.mxText != null && object instanceof Integer) {
            try {
                if (((Integer)object).intValue() != this.mxText.getCaretPosition()) {
                    this.mxText.setCaretPosition(((Integer)object).intValue());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void Update() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.maListeners.size(); ++i) {
            ((ChangeListener)this.maListeners.elementAt(i)).stateChanged(changeEvent);
        }
    }
}

