/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.uno.UnoRuntime;
import javax.swing.JLabel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;

public class TableView
extends ObjectView {
    private XAccessibleTable mxTable;
    private JLabel maRowCountLabel;
    private JLabel maColumnCountLabel;
    private JLabel maCellCountLabel;
    private JLabel maSelectedRowsLabel;
    private JLabel maSelectedColumnsLabel;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (UnoRuntime.queryInterface(XAccessibleTable.class, (Object)xAccessibleContext) != null) {
            return new TableView(objectViewContainer);
        }
        return null;
    }

    public TableView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        ViewGridLayout viewGridLayout = new ViewGridLayout(this);
        this.maRowCountLabel = viewGridLayout.AddLabeledEntry("Row Count: ");
        this.maColumnCountLabel = viewGridLayout.AddLabeledEntry("Column Count: ");
        this.maCellCountLabel = viewGridLayout.AddLabeledEntry("Cell Count: ");
        this.maSelectedRowsLabel = viewGridLayout.AddLabeledEntry("Selected Rows: ");
        this.maSelectedColumnsLabel = viewGridLayout.AddLabeledEntry("Selected Columns: ");
    }

    @Override
    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxTable = (XAccessibleTable)UnoRuntime.queryInterface(XAccessibleTable.class, (Object)xAccessibleContext);
        super.SetObject(xAccessibleContext);
    }

    @Override
    public void Update() {
        if (this.mxTable == null) {
            this.maRowCountLabel.setText("<null object>");
            this.maColumnCountLabel.setText("<null object>");
            this.maCellCountLabel.setText("<null object>");
            this.maSelectedRowsLabel.setText("<null object>");
            this.maSelectedColumnsLabel.setText("<null object>");
        } else {
            int n;
            int n2 = this.mxTable.getAccessibleRowCount();
            int n3 = this.mxTable.getAccessibleColumnCount();
            this.maRowCountLabel.setText(Integer.toString(n2));
            this.maColumnCountLabel.setText(Integer.toString(n3));
            this.maCellCountLabel.setText(Integer.toString(n2 * n3));
            StringBuffer stringBuffer = new StringBuffer();
            int[] nArray = this.mxTable.getSelectedAccessibleRows();
            boolean bl = true;
            for (n = 0; n < nArray.length; ++n) {
                if (!bl) {
                    stringBuffer.append(", ");
                    bl = false;
                }
                stringBuffer.append(Integer.toString(nArray[n]));
            }
            this.maSelectedRowsLabel.setText(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            nArray = this.mxTable.getSelectedAccessibleColumns();
            bl = true;
            for (n = 0; n < nArray.length; ++n) {
                if (!bl) {
                    stringBuffer.append(", ");
                    bl = false;
                }
                stringBuffer.append(Integer.toString(nArray[n]));
            }
            this.maSelectedColumnsLabel.setText(stringBuffer.toString());
        }
    }

    @Override
    public String GetTitle() {
        return "Table";
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 9: 
            case 28: {
                this.Update();
            }
        }
    }
}

