/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.lang.EventObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.openoffice.accessibility.awb.view.ComponentView;
import org.openoffice.accessibility.awb.view.ContextView;
import org.openoffice.accessibility.awb.view.EditableTextView;
import org.openoffice.accessibility.awb.view.EventMonitorView;
import org.openoffice.accessibility.awb.view.FocusView;
import org.openoffice.accessibility.awb.view.LayoutManager;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ParentView;
import org.openoffice.accessibility.awb.view.SelectionView;
import org.openoffice.accessibility.awb.view.ServiceInterfaceView;
import org.openoffice.accessibility.awb.view.StateSetView;
import org.openoffice.accessibility.awb.view.TableView;
import org.openoffice.accessibility.awb.view.TextView;

public class ObjectViewContainer
extends JPanel
implements XAccessibleEventListener {
    private XAccessibleContext mxContext;
    private JTree maTree;
    private Border maViewBorder;
    private Vector maViewTemplates;
    private Font maFont = new Font("Dialog", 0, 11);
    private LayoutManager maLayoutManager;

    public ObjectViewContainer() {
        this.maViewTemplates = new Vector();
        this.maViewBorder = BorderFactory.createBevelBorder(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.maLayoutManager = null;
        this.RegisterView(ContextView.class);
        this.RegisterView(ComponentView.class);
        this.RegisterView(ParentView.class);
        this.RegisterView(StateSetView.class);
        this.RegisterView(FocusView.class);
        this.RegisterView(TextView.class);
        this.RegisterView(EditableTextView.class);
        this.RegisterView(TableView.class);
        this.RegisterView(SelectionView.class);
        this.RegisterView(ServiceInterfaceView.class);
        this.RegisterView(EventMonitorView.class);
        this.mxContext = null;
    }

    public synchronized void SetObject(XAccessibleContext xAccessibleContext) {
        int n;
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            ((ObjectView)this.getComponent(n)).Destroy();
        }
        this.removeAll();
        this.mxContext = xAccessibleContext;
        for (n = 0; n < this.maViewTemplates.size(); ++n) {
            try {
                Class clazz = (Class)this.maViewTemplates.elementAt(n);
                Method method = clazz.getDeclaredMethod("Create", ObjectViewContainer.class, XAccessibleContext.class);
                if (method == null) continue;
                ObjectView objectView = (ObjectView)method.invoke(null, this, xAccessibleContext);
                this.Add(objectView);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Caught exception while creating view " + n + " : " + noSuchMethodException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Caught exception while creating view " + n + " : " + illegalAccessException);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Caught exception while creating view " + n + " : " + invocationTargetException);
            }
        }
        this.UpdateLayoutManager();
        n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            ((ObjectView)this.getComponent(n)).SetObject(xAccessibleContext);
        }
        this.setPreferredSize(this.getLayout().preferredLayoutSize(this));
        ((GridBagLayout)this.getLayout()).invalidateLayout(this);
        this.validate();
    }

    public void RegisterView(Class clazz) {
        this.maViewTemplates.addElement(clazz);
    }

    public void ReplaceView(Class clazz, Class clazz2) {
        int n = this.maViewTemplates.indexOf(clazz);
        if (n >= 0) {
            this.maViewTemplates.setElementAt(clazz2, n);
        }
    }

    public Font GetViewFont() {
        return this.maFont;
    }

    public Color GetErrorColor() {
        return new Color(255, 80, 50);
    }

    private void Add(ObjectView objectView) {
        if (objectView != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 2;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            objectView.setBorder(BorderFactory.createTitledBorder(this.maViewBorder, objectView.GetTitle()));
            this.add((Component)objectView, gridBagConstraints);
        }
    }

    private void UpdateLayoutManager() {
        if (this.getComponentCount() > 1000) {
            Component component = this.getComponent(this.getComponentCount() - 1);
            GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(component, gridBagConstraints);
        }
    }

    public void notifyEvent(final AccessibleEventObject accessibleEventObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectViewContainer.this.DispatchEvent(accessibleEventObject);
            }
        });
    }

    private void DispatchEvent(AccessibleEventObject accessibleEventObject) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((ObjectView)this.getComponent(i)).notifyEvent(accessibleEventObject);
        }
    }

    public void disposing(EventObject eventObject) {
        this.mxContext = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectViewContainer.this.SetObject(null);
            }
        });
    }
}

