/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.misc.AccessibleEventMulticaster;

class AccessibilityNode
extends DefaultMutableTreeNode
implements XAccessible,
XAccessibleEventListener,
XAccessibleEventBroadcaster {
    protected AccessibilityModel treeModel;
    protected XAccessibleContext unoAccessibleContext;
    private XAccessibleEventListener listener;

    public AccessibilityNode(AccessibilityModel accessibilityModel) {
        this.treeModel = accessibilityModel;
    }

    protected void finalize() throws Throwable {
        if (this.userObject != null) {
            this.treeModel.removeNode(this.userObject);
        }
    }

    public void setAccessibleContext(XAccessibleContext xAccessibleContext) {
        this.unoAccessibleContext = xAccessibleContext;
    }

    public XAccessibleContext getAccessibleContext() {
        return this.unoAccessibleContext;
    }

    protected void setAttached(boolean bl) {
        XAccessibleContext xAccessibleContext = this.unoAccessibleContext;
        if (xAccessibleContext != null) {
            try {
                XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)xAccessibleContext);
                if (xAccessibleEventBroadcaster != null) {
                    if (bl) {
                        xAccessibleEventBroadcaster.addEventListener((XAccessibleEventListener)this);
                    } else {
                        xAccessibleEventBroadcaster.removeEventListener((XAccessibleEventListener)this);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void disposing(EventObject eventObject) {
        XAccessibleEventListener xAccessibleEventListener = this.listener;
        if (xAccessibleEventListener != null) {
            xAccessibleEventListener.disposing(eventObject);
        }
        this.treeModel.removeNode(this.userObject);
        this.userObject = null;
        this.unoAccessibleContext = null;
    }

    protected void handleChildRemoved(XAccessible xAccessible) {
        final AccessibilityNode accessibilityNode = this.treeModel.findNode(xAccessible);
        if (accessibilityNode != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccessibilityNode.this.treeModel.removeNodeFromParent(accessibilityNode);
                }
            });
        }
    }

    protected void handleChildAdded(XAccessible xAccessible) {
        final AccessibilityNode accessibilityNode = this;
        final AccessibilityNode accessibilityNode2 = this.treeModel.createNode(xAccessible);
        if (accessibilityNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XAccessibleContext xAccessibleContext = accessibilityNode2.getAccessibleContext();
                        if (xAccessibleContext != null) {
                            AccessibilityNode.this.treeModel.insertNodeInto(accessibilityNode2, accessibilityNode, xAccessibleContext.getAccessibleIndexInParent());
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        XAccessibleEventListener xAccessibleEventListener;
        if (accessibleEventObject.EventId == 7) {
            xAccessibleEventListener = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)accessibleEventObject.OldValue);
            if (xAccessibleEventListener != null) {
                this.handleChildRemoved((XAccessible)xAccessibleEventListener);
            }
            if ((xAccessibleEventListener = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)accessibleEventObject.NewValue)) != null) {
                this.handleChildAdded((XAccessible)xAccessibleEventListener);
            }
        }
        if ((xAccessibleEventListener = this.listener) != null) {
            xAccessibleEventListener.notifyEvent(accessibleEventObject);
        }
    }

    public synchronized void addEventListener(XAccessibleEventListener xAccessibleEventListener) {
        this.listener = AccessibleEventMulticaster.add(this.listener, xAccessibleEventListener);
    }

    public synchronized void removeEventListener(XAccessibleEventListener xAccessibleEventListener) {
        this.listener = AccessibleEventMulticaster.remove(this.listener, xAccessibleEventListener);
    }
}

