/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.java.XJavaVM;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.accessibility.AccessBridge;
import org.openoffice.accessibility.PopupWindow;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class WindowsAccessBridgeAdapter {
    private static Method registerVirtualFrame;
    private static Method revokeVirtualFrame;
    private static Hashtable frameMap;

    protected static native byte[] getProcessID();

    protected static native boolean createMapping(long var0);

    protected static void attach(XComponentContext xComponentContext) {
        try {
            Class<?> clazz = Class.forName("com.sun.java.accessibility.AccessBridge");
            Class[] classArray = new Class[]{Accessible.class, Integer.class};
            if (clazz != null) {
                XJavaVM xJavaVM;
                registerVirtualFrame = clazz.getMethod("registerVirtualFrame", classArray);
                revokeVirtualFrame = clazz.getMethod("revokeVirtualFrame", classArray);
                System.loadLibrary("java_uno_accessbridge");
                Object object = xComponentContext.getValueByName("/singletons/com.sun.star.java.theJavaVirtualMachine");
                if (AnyConverter.isObject((Object)object) && (xJavaVM = (XJavaVM)UnoRuntime.queryInterface(XJavaVM.class, (Object)AnyConverter.toObject((Type)new Type(XJavaVM.class), (Object)object))) != null && AnyConverter.isLong((Object)(object = xJavaVM.getJavaVM(WindowsAccessBridgeAdapter.getProcessID())))) {
                    WindowsAccessBridgeAdapter.createMapping(AnyConverter.toLong((Object)object));
                    frameMap = new Hashtable();
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ERROR: incompatible AccessBridge found: " + noSuchMethodException.getMessage());
            throw new RuntimeException("incompatible AccessBridge class: " + noSuchMethodException.getMessage());
        }
        catch (SecurityException securityException) {
            System.err.println("ERROR: no access to AccessBridge: " + securityException.getMessage());
            throw new RuntimeException("Security exception caught: " + securityException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("ClassNotFound exception caught: " + classNotFoundException.getMessage());
        }
        catch (java.lang.IllegalArgumentException illegalArgumentException) {
            System.err.println("IllegalArgumentException caught: " + illegalArgumentException.getMessage());
            throw new RuntimeException("IllegalArgumentException caught: " + illegalArgumentException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("UNO IllegalArgumentException caught: " + illegalArgumentException.getMessage());
            throw new RuntimeException("UNO IllegalArgumentException caught: " + illegalArgumentException.getMessage());
        }
    }

    protected static boolean isAttached() {
        return frameMap != null;
    }

    protected static Accessible getAccessibleWrapper(XAccessible xAccessible) {
        Accessible accessible;
        block9: {
            accessible = null;
            try {
                XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                if (xAccessibleContext == null) break block9;
                switch (xAccessibleContext.getAccessibleRole()) {
                    case 32: {
                        accessible = (Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(xAccessible));
                        if (accessible != null) {
                            accessible = new ListProxy(accessible.getAccessibleContext());
                        }
                        break;
                    }
                    case 34: {
                        AccessibleContext accessibleContext;
                        Accessible accessible2 = (Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(xAccessible));
                        if (accessible2 != null && (accessibleContext = accessible2.getAccessibleContext()) != null) {
                            accessible = new PopupMenuProxy(accessibleContext);
                        }
                        break;
                    }
                    case 64: {
                        accessible = PopupWindow.create(xAccessible);
                        break;
                    }
                    default: {
                        accessible = AccessBridge.getTopWindow(xAccessible);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return accessible;
    }

    public static void registerTopWindow(int n, XAccessible xAccessible) {
        Accessible accessible;
        Integer n2 = new Integer(n);
        if (!frameMap.contains(n2) && (accessible = WindowsAccessBridgeAdapter.getAccessibleWrapper(xAccessible)) != null) {
            Object[] objectArray = new Object[]{accessible, n2};
            frameMap.put(n2, accessible);
            try {
                registerVirtualFrame.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("IllegalAccessException caught: " + illegalAccessException.getMessage());
            }
            catch (java.lang.IllegalArgumentException illegalArgumentException) {
                System.err.println("IllegalArgumentException caught: " + illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("InvokationTargetException caught: " + invocationTargetException.getMessage());
            }
        }
    }

    public static void revokeTopWindow(int n, XAccessible xAccessible) {
        Object[] objectArray;
        Integer n2 = new Integer(n);
        Accessible accessible = (Accessible)frameMap.remove(n2);
        if (accessible != null) {
            objectArray = new Object[]{accessible, n2};
            try {
                revokeVirtualFrame.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("IllegalAccessException caught: " + illegalAccessException.getMessage());
            }
            catch (java.lang.IllegalArgumentException illegalArgumentException) {
                System.err.println("IllegalArgumentException caught: " + illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("InvokationTargetException caught: " + invocationTargetException.getMessage());
            }
        }
        if (accessible instanceof PopupWindow) {
            objectArray = (Object[])accessible;
            objectArray.removeAll();
            objectArray.dispose();
        }
    }

    protected static class ListProxy
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        AccessibleContext list;
        AccessibleComponent listComponent;

        ListProxy(AccessibleContext accessibleContext) {
            this.list = accessibleContext;
            this.listComponent = this.list.getAccessibleComponent();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this.list.getAccessibleSelection();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return this.list.getAccessibleStateSet();
        }

        @Override
        public Locale getLocale() {
            return this.list.getLocale();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.list.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return this.list.getAccessibleChild(n);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            this.listComponent.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            this.listComponent.removeFocusListener(focusListener);
        }

        @Override
        public Color getBackground() {
            return this.listComponent.getBackground();
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return this.listComponent.getForeground();
        }

        @Override
        public void setForeground(Color color) {
            this.listComponent.setForeground(color);
        }

        @Override
        public Cursor getCursor() {
            return this.listComponent.getCursor();
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.listComponent.setCursor(cursor);
        }

        @Override
        public Font getFont() {
            return this.listComponent.getFont();
        }

        @Override
        public void setFont(Font font) {
            this.listComponent.setFont(font);
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return this.listComponent.getFontMetrics(font);
        }

        @Override
        public boolean isEnabled() {
            return this.listComponent.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.listComponent.setEnabled(bl);
        }

        @Override
        public boolean isVisible() {
            return this.listComponent.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
            this.listComponent.setVisible(bl);
        }

        @Override
        public boolean isShowing() {
            return this.listComponent.isShowing();
        }

        @Override
        public boolean contains(Point point) {
            return this.listComponent.contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            return this.listComponent.getLocationOnScreen();
        }

        @Override
        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            Point point = this.getLocationOnScreen();
            Dimension dimension = this.getSize();
            return new Rectangle(point.x, point.y, dimension.width, dimension.height);
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            return this.listComponent.getSize();
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return this.listComponent.getAccessibleAt(point);
        }

        @Override
        public boolean isFocusTraversable() {
            return this.listComponent.isFocusTraversable();
        }

        @Override
        public void requestFocus() {
            this.listComponent.requestFocus();
        }
    }

    protected static class PopupMenuProxy
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        AccessibleContext menu;
        AccessibleComponent menuComponent;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;

        PopupMenuProxy(AccessibleContext accessibleContext) {
            this.menu = accessibleContext;
            this.menuComponent = this.menu.getAccessibleComponent();
            int n = 0;
            int n2 = 0;
            int n3 = accessibleContext.getAccessibleChildrenCount();
            for (int i = 0; i < n3; ++i) {
                AccessibleComponent accessibleComponent;
                AccessibleContext accessibleContext2;
                Accessible accessible = this.menu.getAccessibleChild(i);
                if (accessible == null || (accessibleContext2 = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null) continue;
                Point point = accessibleComponent.getLocationOnScreen();
                Dimension dimension = accessibleComponent.getSize();
                if (point == null || dimension == null) continue;
                if (point.x < this.x) {
                    this.x = point.x;
                }
                if (point.y < this.y) {
                    this.y = point.y;
                }
                if (point.x + dimension.width > n) {
                    n = point.x + dimension.width;
                }
                if (point.y + dimension.height <= n2) continue;
                n2 = point.y + dimension.height;
            }
            this.width = n - this.x;
            this.height = n2 - this.y;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this.menu.getAccessibleText();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return this.menu.getAccessibleStateSet();
        }

        @Override
        public Locale getLocale() {
            return this.menu.getLocale();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.menu.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return this.menu.getAccessibleChild(n);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            this.menuComponent.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            this.menuComponent.removeFocusListener(focusListener);
        }

        @Override
        public Color getBackground() {
            return this.menuComponent.getBackground();
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return this.menuComponent.getForeground();
        }

        @Override
        public void setForeground(Color color) {
            this.menuComponent.setForeground(color);
        }

        @Override
        public Cursor getCursor() {
            return this.menuComponent.getCursor();
        }

        @Override
        public void setCursor(Cursor cursor) {
            this.menuComponent.setCursor(cursor);
        }

        @Override
        public Font getFont() {
            return this.menuComponent.getFont();
        }

        @Override
        public void setFont(Font font) {
            this.menuComponent.setFont(font);
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return this.menuComponent.getFontMetrics(font);
        }

        @Override
        public boolean isEnabled() {
            return this.menuComponent.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.menuComponent.setEnabled(bl);
        }

        @Override
        public boolean isVisible() {
            return this.menuComponent.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
            this.menuComponent.setVisible(bl);
        }

        @Override
        public boolean isShowing() {
            return this.menuComponent.isShowing();
        }

        @Override
        public boolean contains(Point point) {
            Dimension dimension = this.getSize();
            return dimension.width >= 0 && point.x < dimension.width && dimension.height >= 0 && point.y < dimension.height;
        }

        @Override
        public Point getLocationOnScreen() {
            return new Point(this.x, this.y);
        }

        @Override
        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            Point point2 = this.menuComponent.getLocationOnScreen();
            return this.menuComponent.getAccessibleAt(new Point(point.x + this.x - point2.x, point.y + this.y - point2.y));
        }

        @Override
        public boolean isFocusTraversable() {
            return this.menuComponent.isFocusTraversable();
        }

        @Override
        public void requestFocus() {
            this.menuComponent.requestFocus();
        }
    }
}

