/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.space;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.space.DesignDim;

public class DesignSpace {
    private DesignDim[] dimProps;

    public DesignSpace(int dim) {
        this.dimProps = new DesignDim[dim];
    }

    public DesignDim getDimAt(int index) {
        return this.dimProps[index];
    }

    public void setElemAt(DesignDim elem, int index) {
        this.dimProps[index] = elem;
    }

    public int getDimension() {
        if (this.dimProps == null) {
            return -1;
        }
        return this.dimProps.length;
    }

    public double boundAdjustAt(double val, int dim) {
        return this.dimProps[dim].paramBound.boundAdjust(val);
    }

    public void annulusAdjust(double[] location) {
        for (int i = 0; i < this.getDimension(); ++i) {
            location[i] = this.dimProps[i].paramBound.annulusAdjust(location[i]);
        }
    }

    public void randomAdjust(double[] location) {
        for (int i = 0; i < this.getDimension(); ++i) {
            location[i] = this.dimProps[i].paramBound.randomAdjust(location[i]);
        }
    }

    public boolean satisfyCondition(double[] location) {
        for (int i = 0; i < this.getDimension(); ++i) {
            if (this.dimProps[i].paramBound.isSatisfyCondition(location[i])) continue;
            return false;
        }
        return true;
    }

    public void mutationAt(double[] location, int i) {
        location[i] = this.dimProps[i].paramBound.getRandomValue();
    }

    public double mutationUniformAtPointAsCenter(double pointX, int i) {
        double length = this.getMagnitudeIn(i) / 2.0;
        return pointX += RandomGenerator.doubleRangeRandom(-1.0 * length, length);
    }

    public double getUpValueAt(int dimensionIndex) {
        return this.dimProps[dimensionIndex].paramBound.maxValue;
    }

    public double getLowValueAt(int dimensionIndex) {
        return this.dimProps[dimensionIndex].paramBound.minValue;
    }

    public double getMagnitudeIn(int dimensionIndex) {
        return this.dimProps[dimensionIndex].paramBound.getLength();
    }

    public boolean initilizeGeneAtPointAsCenter(double[] tempX) {
        if (tempX.length != this.getDimension()) {
            return false;
        }
        int i = 0;
        while (i < tempX.length) {
            double length = this.getMagnitudeIn(i) / 2.0;
            int n = i++;
            tempX[n] = tempX[n] + RandomGenerator.doubleRangeRandom(-1.0 * length, length);
        }
        return true;
    }

    public void initializeGene(double[] tempX) {
        for (int i = 0; i < tempX.length; ++i) {
            tempX[i] = this.dimProps[i].paramBound.getRandomValue();
        }
    }

    public double[] getFreshGene() {
        double[] tempX = new double[this.getDimension()];
        this.initializeGene(tempX);
        return tempX;
    }

    public void getMappingPoint(double[] point) {
        for (int i = 0; i < this.getDimension(); ++i) {
            point[i] = this.dimProps[i].paramBound.annulusAdjust(point[i]);
            if (!this.dimProps[i].isDiscrete()) continue;
            point[i] = this.dimProps[i].getGrainedValue(point[i]);
        }
    }

    public double[] getRealLoc(double[] imageLoc) {
        double[] realLoc = new double[imageLoc.length];
        for (int i = 0; i < imageLoc.length; ++i) {
            realLoc[i] = imageLoc[i];
        }
        this.annulusAdjust(realLoc);
        return realLoc;
    }
}

