/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.knowledge;

import net.adaptivebox.encode.IEncodeEngine;
import net.adaptivebox.global.OutputMethods;
import net.adaptivebox.space.BasicPoint;

public class SearchPoint
extends BasicPoint
implements IEncodeEngine {
    private double[] encodeInfo = new double[2];
    private double objectiveValue;

    public SearchPoint(int dim) {
        super(dim);
        for (int i = 0; i < this.encodeInfo.length; ++i) {
            this.encodeInfo[i] = 1.0E308;
        }
    }

    public double[] getEncodeInfo() {
        return this.encodeInfo;
    }

    private void importEncodeInfo(double[] info) {
        for (int i = 0; i < this.encodeInfo.length; ++i) {
            this.encodeInfo[i] = info[i];
        }
    }

    private void importEncodeInfo(IEncodeEngine point) {
        this.importEncodeInfo(point.getEncodeInfo());
    }

    public void importPoint(SearchPoint point) {
        this.importLocation(point);
        this.importEncodeInfo(point);
        this.setObjectiveValue(point.getObjectiveValue());
    }

    public double getObjectiveValue() {
        return this.objectiveValue;
    }

    public void setObjectiveValue(double objectiveValue) {
        this.objectiveValue = objectiveValue;
    }

    public boolean isFeasible() {
        return this.encodeInfo[0] == 0.0;
    }

    public void outputSelf() {
        System.out.println("#--> Location:");
        OutputMethods.outputVector(this.getLocation());
        System.out.println("#--> (CON & OPTIM):");
        OutputMethods.outputVector(this.getEncodeInfo());
    }
}

