/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.goodness;

import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;

public class ACRComparator
implements IGoodnessCompareEngine,
IUpdateCycleEngine {
    private Library socialPool;
    private double epsilon_t = 0.0;
    private double RU = 0.75;
    private double RL = 0.25;
    private double BETAF = 0.618;
    private double BETAL = 0.618;
    private double BETAU = 1.382;
    private double T = -1.0;
    private double TthR = 0.5;

    public ACRComparator(Library lib, int T) {
        this.socialPool = lib;
        this.T = T;
        this.epsilon_t = lib.getExtremalVcon(true);
    }

    public static int compare(double data1, double data2) {
        if (data1 < data2) {
            return 0;
        }
        if (data1 > data2) {
            return 2;
        }
        return 1;
    }

    public int compare(double[] fit1, double[] fit2) {
        if (Math.max(fit1[0], fit2[0]) <= Math.max(0.0, this.epsilon_t)) {
            return ACRComparator.compare(fit1[1], fit2[1]);
        }
        return ACRComparator.compare(fit1[0], fit2[0]);
    }

    public void updateCycle(int t) {
        double rn = (double)this.socialPool.getVconThanNum(this.epsilon_t) / (double)this.socialPool.getPopSize();
        if ((double)t > this.TthR * this.T && this.T != -1.0) {
            this.epsilon_t *= this.BETAF;
        } else {
            if (rn > this.RU) {
                this.epsilon_t *= this.BETAL;
            }
            if (rn < this.RL) {
                this.epsilon_t *= this.BETAU;
            }
        }
    }
}

