/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

public class RandomGenerator {
    public static int intRangeRandom(int lowLimit, int upLimit) {
        int num = (int)Math.floor(RandomGenerator.doubleRangeRandom(lowLimit, upLimit + 1) - 1.0E-10);
        return num;
    }

    public static double doubleRangeRandom(double lowLimit, double upLimit) {
        double num = lowLimit + Math.random() * (upLimit - lowLimit);
        return num;
    }

    public static boolean booleanRandom() {
        boolean value = true;
        double temp = Math.random();
        if (temp < 0.5) {
            value = false;
        }
        return value;
    }

    public static int[] randomSelection(boolean[] types, int times) {
        int validNum = 0;
        for (int i = 0; i < types.length; ++i) {
            if (types[i]) continue;
            ++validNum;
        }
        int[] totalIndices = new int[validNum];
        validNum = 0;
        for (int i = 0; i < types.length; ++i) {
            if (types[i]) continue;
            totalIndices[validNum] = i;
            if (++validNum == totalIndices.length) break;
        }
        return RandomGenerator.randomSelection(totalIndices, times);
    }

    public static int[] randomSelection(int low, int up, int times) {
        int[] totalIndices = new int[up - low];
        for (int i = low; i < up; ++i) {
            totalIndices[i] = i;
        }
        return RandomGenerator.randomSelection(totalIndices, times);
    }

    public static int getRealV(double randTypeV) {
        if (randTypeV <= 0.0) {
            return 0;
        }
        int realV = (int)Math.ceil(randTypeV);
        if (Math.random() < randTypeV - (double)realV) {
            ++realV;
        }
        return realV;
    }

    public static int[] randomSelection(int[] totalIndices, int times) {
        if (times >= totalIndices.length) {
            return totalIndices;
        }
        int[] indices = RandomGenerator.randomSelection(totalIndices.length, times);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = totalIndices[indices[i]];
        }
        return indices;
    }

    public static int[] randomSelection(int maxNum, int times) {
        if (times <= 0) {
            return new int[0];
        }
        int realTimes = Math.min(maxNum, times);
        boolean[] flags = new boolean[maxNum];
        boolean isBelowHalf = (double)times < (double)maxNum * 0.5;
        int virtualTimes = realTimes;
        if (!isBelowHalf) {
            virtualTimes = maxNum - realTimes;
        }
        int i = 0;
        int upper = maxNum - 1;
        int[] indices = new int[realTimes];
        while (i < virtualTimes) {
            indices[i] = RandomGenerator.intRangeRandom(0, upper);
            if (flags[indices[i]]) continue;
            flags[indices[i]] = true;
            ++i;
        }
        if (!isBelowHalf) {
            int j = 0;
            for (i = 0; i < maxNum; ++i) {
                if (flags[i] != isBelowHalf) continue;
                indices[j] = i;
                if (++j == realTimes) break;
            }
        }
        return indices;
    }
}

