/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class GlobalString {
    public static final String NEGLECT_TAG = "#$@";
    public static final String EQUAL_TAG = "=";

    public static String[] tokenize(String input, String tokenKey) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, tokenKey);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String[] getMeaningfulLines(String srcStr) throws Exception {
        return GlobalString.getMeaningfulLines(srcStr, NEGLECT_TAG);
    }

    public static String getMeaningfulLine(BufferedReader outReader) throws Exception {
        return GlobalString.getMeaningfulLine(outReader, NEGLECT_TAG);
    }

    public static int getCharLoc(char data, String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != data) continue;
            return i;
        }
        return -1;
    }

    public static String trim(String origStr, String discardStr) {
        String str = origStr;
        while (true) {
            if (str.length() == 0) {
                return str;
            }
            if (GlobalString.getCharLoc(str.charAt(0), discardStr) != -1) {
                str = str.substring(1);
                continue;
            }
            if (GlobalString.getCharLoc(str.charAt(str.length() - 1), discardStr) == -1) break;
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static boolean getFirstCharExist(String str, String chars) throws Exception {
        int neglectFirstCharLength = chars.length();
        for (int i = 0; i < neglectFirstCharLength; ++i) {
            if (!str.startsWith(chars.substring(i, i + 1))) continue;
            return true;
        }
        return false;
    }

    public static String getMeaningfulLine(BufferedReader outReader, String neglectFirstChars) throws Exception {
        String str;
        boolean isNeglect = true;
        boolean i = false;
        do {
            if ((str = outReader.readLine()) == null) {
                return null;
            }
            if ((str = GlobalString.trim(str, " \t")).length() <= 0) continue;
            isNeglect = GlobalString.getFirstCharExist(str, neglectFirstChars);
        } while (isNeglect);
        return str;
    }

    public static String[] getMeaningfulLines(String srcStr, String neglectFirstChars) throws Exception {
        StringReader outStringReader = new StringReader(srcStr);
        BufferedReader outReader = new BufferedReader(outStringReader);
        Vector<String> origData = new Vector<String>();
        String str = null;
        while ((str = GlobalString.getMeaningfulLine(outReader, neglectFirstChars)) != null) {
            origData.add(str);
        }
        return GlobalString.convert1DVectorToStringArray(origData);
    }

    public static String[] convert1DVectorToStringArray(Vector toToConvert) {
        if (toToConvert == null) {
            return null;
        }
        String[] objs = new String[toToConvert.size()];
        for (int i = 0; i < toToConvert.size(); ++i) {
            objs[i] = GlobalString.getObjString(toToConvert.elementAt(i));
        }
        return objs;
    }

    public static String getObjString(Object nObj) {
        if (nObj instanceof String) {
            return (String)nObj;
        }
        return nObj.toString();
    }

    public static int toInteger(Object oVal) throws Exception {
        if (oVal == null) {
            throw new Exception("Null string");
        }
        return new Integer(oVal.toString());
    }

    public static double toDouble(Object oVal) throws Exception {
        if (oVal == null) {
            throw new Exception("Null string");
        }
        return new Double(oVal.toString());
    }

    public static Object toObject(String key) throws Exception {
        Class<?> cls = Class.forName(key);
        return cls.newInstance();
    }
}

