/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.Vector;
import net.adaptivebox.global.BasicTag;
import net.adaptivebox.global.GlobalString;

public class GlobalFile {
    private static int counter = -1;

    public static File createTempDir(String prefix, String directory) throws IOException {
        String tempDir;
        File f = null;
        boolean isCreated = false;
        do {
            if (counter == -1) {
                counter = new Random().nextInt() & 0xFFFF;
            }
            ++counter;
            if (prefix == null) {
                throw new NullPointerException();
            }
            if (prefix.length() >= 3) continue;
            throw new IllegalArgumentException("Prefix string too short");
        } while (!(isCreated = (f = new File(tempDir = directory == null ? prefix + counter : GlobalFile.getFileLocation(directory, prefix + counter))).mkdir()));
        return f;
    }

    public static void addStringToFile(String inStr, String fileStr) throws Exception {
        RandomAccessFile raFile = new RandomAccessFile(fileStr, "rw");
        raFile.seek(raFile.length());
        raFile.writeBytes(inStr);
        raFile.close();
    }

    public static Object loadObjectFromFile(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static void saveObjectToFile(String fileName, Object obj) throws Exception {
        FileOutputStream ostream = new FileOutputStream(fileName);
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(obj);
        p.flush();
        ostream.close();
    }

    public static void saveStringToFile(String inStr, String fileStr) throws Exception {
        new File(new File(fileStr).getParent()).mkdirs();
        FileOutputStream pspOutputStream = new FileOutputStream(new File(fileStr));
        pspOutputStream.write(inStr.getBytes());
        pspOutputStream.close();
    }

    public static String getStringFromFile(String fileStr) throws Exception {
        String getStr = null;
        FileInputStream pspInputStream = new FileInputStream(fileStr);
        byte[] pspFileBuffer = new byte[pspInputStream.available()];
        pspInputStream.read(pspFileBuffer);
        pspInputStream.close();
        getStr = new String(pspFileBuffer);
        return getStr;
    }

    /*
     * Exception decompiling
     */
    public static Vector getCurveDataFromFile(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFileLocation(String dir, String fileName) {
        String realDir = dir;
        while (realDir.length() > 0 && (realDir.endsWith("/") || realDir.endsWith("\\"))) {
            realDir = dir.substring(0, dir.length() - 1);
        }
        return realDir + BasicTag.FILE_SEP_TAG + fileName;
    }

    public static String getFileName(String nameBody, String suffix) {
        if (suffix == null || suffix.trim().length() == 0) {
            return nameBody;
        }
        String fileName = nameBody;
        if (nameBody.endsWith(".")) {
            return fileName + suffix;
        }
        return nameBody + "." + suffix;
    }

    public static String getFileLocation(String dir, String fileNameBody, String fileNameSuffix) {
        String filename = GlobalFile.getFileName(fileNameBody, fileNameSuffix);
        return GlobalFile.getFileLocation(dir, filename);
    }

    public static void clear(String fileStr) throws Exception {
        File file = new File(fileStr);
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] fileNames = file.list();
        if (fileNames == null) {
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            String newFileName = GlobalFile.getFileLocation(fileStr, fileNames[i]);
            GlobalFile.clear(newFileName);
        }
        file.delete();
    }

    public static String getFilePrefix(String fileStr) {
        int index = fileStr.lastIndexOf(".");
        if (index == -1) {
            index = fileStr.length();
        }
        return fileStr.substring(0, index);
    }

    public static String getFileSuffix(String fileStr) {
        String[] subNames = GlobalString.tokenize(fileStr, ".");
        int subNameLen = subNames.length;
        if (subNameLen == 1) {
            return "";
        }
        return subNames[subNameLen - 1];
    }

    public static String createTempImageFile(String origFile) throws Exception {
        return GlobalFile.createTempImageFile(origFile, "img", ".inf");
    }

    public static String createTempImageFile(String origFile, String prefix, String suffix) throws Exception {
        File outputFile = GlobalFile.createTempFile(prefix, suffix);
        outputFile.deleteOnExit();
        GlobalFile.copyFile(outputFile.getAbsolutePath(), origFile);
        return outputFile.getAbsolutePath();
    }

    public static void copyFile(String imgFile, String origFile) throws Exception {
        String fileContent = GlobalFile.getStringFromFile(origFile);
        GlobalFile.saveStringToFile(fileContent, imgFile);
    }

    public static File createTempFile(String prefix, String suffix) throws Exception {
        String realSuffix = suffix;
        if (!realSuffix.startsWith(".")) {
            realSuffix = "." + suffix;
        }
        return File.createTempFile(prefix, realSuffix);
    }
}

