/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import net.adaptivebox.global.RandomGenerator;

public class BasicBound {
    public static final double MINDOUBLE = -1.0E308;
    public static final double MAXDOUBLE = 1.0E308;
    public double minValue = -1.0E308;
    public double maxValue = 1.0E308;

    public BasicBound() {
    }

    public BasicBound(double min, double max) {
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(min, max);
    }

    public double getLength() {
        return Math.abs(this.maxValue - this.minValue);
    }

    public boolean isSatisfyCondition(double child) {
        return !(child > this.maxValue) && !(child < this.minValue);
    }

    public double boundAdjust(double value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        return value;
    }

    public double annulusAdjust(double value) {
        if (value > this.maxValue) {
            double extendsLen = (value - this.maxValue) % this.getLength();
            value = this.minValue + extendsLen;
        } else if (value < this.minValue) {
            double extendsLen = (this.minValue - value) % this.getLength();
            value = this.maxValue - extendsLen;
        }
        return value;
    }

    public static BasicBound getBound(double[] data) {
        BasicBound bound = new BasicBound();
        if (data != null && data.length > 0) {
            bound.minValue = data[0];
            bound.maxValue = data[0];
            for (int i = 1; i < data.length; ++i) {
                bound.minValue = Math.min(bound.minValue, data[i]);
                bound.maxValue = Math.max(bound.maxValue, data[i]);
            }
        }
        return bound;
    }

    public double randomAdjust(double value) {
        if (value > this.maxValue || value < this.minValue) {
            value = this.getRandomValue();
        }
        return value;
    }

    public double getRandomValue() {
        return RandomGenerator.doubleRangeRandom(this.minValue, this.maxValue);
    }
}

