/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver.dialogs.controls;

import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseControl {
    protected XComponentContext context;
    private Object unoModel;
    protected Object unoControl;
    protected XPropertySet properties;
    protected BaseControl parentControl;

    public abstract String getName();

    public Object getUnoModel() {
        return this.unoModel;
    }

    protected void setUnoModel(Object unoModel) {
        this.unoModel = unoModel;
        this.properties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)unoModel);
    }

    public Object getUnoControl() {
        return this.unoControl;
    }

    public void setParentControl(BaseControl parentControl) {
        try {
            String name = this.getName();
            XNameContainer nameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)parentControl.unoModel);
            nameContainer.insertByName(name, this.unoModel);
            XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)parentControl.unoControl);
            this.unoControl = controlContainer.getControl(name);
            this.parentControl = parentControl;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ElementExistException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WrappedTargetException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public BaseControl(XComponentContext context) {
        this.context = context;
        this.unoModel = null;
        this.unoControl = null;
        this.parentControl = null;
    }

    protected void setProperty(String name, Object value) {
        try {
            this.properties.setPropertyValue(name, value);
        }
        catch (UnknownPropertyException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WrappedTargetException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected Object getProperty(String name) {
        try {
            return this.properties.getPropertyValue(name);
        }
        catch (UnknownPropertyException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WrappedTargetException ex) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void setPosition(int x, int y) {
        this.setProperty("PositionX", new Integer(x));
        this.setProperty("PositionY", new Integer(y));
    }

    public void setSize(int width, int height) {
        this.setProperty("Width", new Integer(width));
        this.setProperty("Height", new Integer(height));
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("Enabled", new Boolean(enabled));
    }

    public void setVisible(boolean visible) {
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.unoControl);
        xWindow.setVisible(visible);
    }
}

