/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.deployment.PackageInformationProvider;
import com.sun.star.deployment.XPackageInformationProvider;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.resource.MissingResourceException;
import com.sun.star.resource.StringResourceWithLocation;
import com.sun.star.resource.XStringResourceWithLocation;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class ResourceManager {
    private final XComponentContext m_context;
    private final String m_oxtRoot;
    private final String m_resourceBaseUrl;
    private final String m_resourceBasename;
    private XStringResourceWithLocation m_xStrResource;
    private Locale m_locale;

    public ResourceManager(XComponentContext xContext, String oxtId, String relativeResourceBaseUrl, String resourceBasename) {
        this.m_context = xContext;
        this.m_resourceBasename = resourceBasename;
        XPackageInformationProvider xPkgInfo = PackageInformationProvider.get((XComponentContext)this.m_context);
        this.m_oxtRoot = xPkgInfo.getPackageLocation(oxtId);
        this.m_resourceBaseUrl = this.m_oxtRoot + relativeResourceBaseUrl;
        try {
            XMultiServiceFactory xConfig = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.m_context.getServiceManager().createInstanceWithContext("com.sun.star.configuration.ConfigurationProvider", this.m_context));
            Object[] args = new Object[]{new PropertyValue("nodepath", 0, (Object)"/org.openoffice.Setup/L10N", PropertyState.DIRECT_VALUE)};
            XPropertySet xConfigProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xConfig.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", args));
            String[] locale = AnyConverter.toString((Object)xConfigProps.getPropertyValue("ooLocale")).split("-");
            String lang = locale[0];
            String country = locale.length >= 2 ? locale[1] : "";
            String variant = locale.length >= 3 ? locale[2] : "";
            this.m_locale = new Locale(lang, country, variant);
            this.m_xStrResource = StringResourceWithLocation.create((XComponentContext)this.m_context, (String)this.m_resourceBaseUrl, (boolean)true, (Locale)this.m_locale, (String)this.m_resourceBasename, (String)"", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getLocalizedString(String key) throws MissingResourceException {
        return this.m_xStrResource.resolveString(this.m_resourceBasename + "." + key);
    }

    public String getLocalizedString(String key, String defaultValue) {
        try {
            return this.m_xStrResource.resolveString(this.m_resourceBasename + "." + key);
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }
}

